<?php
/**
 * Plugin Name: YITH WooCommerce Customize My Account Page Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-customize-myaccount-page
 * Description: The <code><strong>YITH WooCommerce Customize My Account Page</strong></code> lets you customize the layout of the "My Account" page, adds new endpoints and manage its content easily. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>.
 * Version: 3.20.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-woocommerce-customize-myaccount-page
 * Domain Path: /languages/
 * WC requires at least: 7.2
 * WC tested up to: 7.4
 *
 * @author  YITH
 * @package YITH WooCommerce Customize My Account Page
 * @version 3.20.0
 */

/*
Copyright 2015-2022 Your Inspiration Solutions (email : plugins@yithemes.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
load_plugin_textdomain('yith-woocommerce-customize-myaccount-page', false, basename( dirname( __FILE__ ) ) . '/languages' );
defined( 'ABSPATH' ) || exit;
function load_yith_li_customize() {
    $license_options = get_option('yit_products_licence_activation', array());
    $license_options['yith-woocommerce-customize-myaccount-page']['activated'] = true;
    $license_options['yith-woocommerce-customize-myaccount-page']['email'] = 'email@email.com';
    $license_options['yith-woocommerce-customize-myaccount-page']['licence_key'] = '****-****-****-************';
    $license_options['yith-woocommerce-customize-myaccount-page']['activation_limit'] = '999';
    $license_options['yith-woocommerce-customize-myaccount-page']['activation_remaining'] = '999';
    $license_options['yith-woocommerce-customize-myaccount-page']['licence_expires'] = the_date();
    update_option( 'yit_products_licence_activation', $license_options);
    update_option( 'yit_plugin_licence_activation', $license_options);
    update_option( 'yit_theme_licence_activation', $license_options);
}
add_action('init', 'load_yith_li_customize');
if ( ! function_exists( 'yith_wcmap_install_woocommerce_admin_notice' ) ) {
	/**
	 * Add notice if WooCommerce is missing.
	 *
	 * @since  1.0.0
	 * @author Francesco Licandro
	 */
	function yith_wcmap_install_woocommerce_admin_notice() {
		?>
		<div class="error">
			<p><?php echo wp_kses_post( __( '<b>YITH WooCommerce Customize My Account Page</b> is enabled but not effective. It requires WooCommerce in order to work.', 'yith-woocommerce-customize-myaccount-page' ) ); ?></p>
		</div>
		<?php
	}
}

defined( 'YITH_WCMAP_VERSION' ) || define( 'YITH_WCMAP_VERSION', '3.20.0' );
defined( 'YITH_WCMAP_PREMIUM' ) || define( 'YITH_WCMAP_PREMIUM', true );
defined( 'YITH_WCMAP_INIT' ) || define( 'YITH_WCMAP_INIT', plugin_basename( __FILE__ ) );
defined( 'YITH_WCMAP' ) || define( 'YITH_WCMAP', true );
defined( 'YITH_WCMAP_FILE' ) || define( 'YITH_WCMAP_FILE', __FILE__ );
defined( 'YITH_WCMAP_URL' ) || define( 'YITH_WCMAP_URL', plugin_dir_url( __FILE__ ) );
defined( 'YITH_WCMAP_DIR' ) || define( 'YITH_WCMAP_DIR', plugin_dir_path( __FILE__ ) );
defined( 'YITH_WCMAP_TEMPLATE_PATH' ) || define( 'YITH_WCMAP_TEMPLATE_PATH', YITH_WCMAP_DIR . 'templates/' );
defined( 'YITH_WCMAP_ASSETS_URL' ) || define( 'YITH_WCMAP_ASSETS_URL', YITH_WCMAP_URL . 'assets' );
defined( 'YITH_WCMAP_SLUG' ) || define( 'YITH_WCMAP_SLUG', 'yith-woocommerce-customize-myaccount-page' );
defined( 'YITH_WCMAP_SECRET_KEY' ) || define( 'YITH_WCMAP_SECRET_KEY', '' );

/* Plugin Framework Version Check */
if ( ! function_exists( 'yit_maybe_plugin_fw_loader' ) && file_exists( YITH_WCMAP_DIR . 'plugin-fw/init.php' ) ) {
	require_once YITH_WCMAP_DIR . 'plugin-fw/init.php';
}
yit_maybe_plugin_fw_loader( YITH_WCMAP_DIR );

if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}

// Require plugin autoload.
if ( ! class_exists( 'YITH_WCMAP_Autoloader', false ) ) {
	require_once YITH_WCMAP_DIR . 'includes/class-yith-wcmap-autoloader.php';
}

if ( ! function_exists( 'yith_wcmap_init' ) ) {
	/**
	 * Install plugin.
	 *
	 * @since  1.0.0
	 * @author Francesco Licandro
	 */
	function yith_wcmap_init() {
		if ( ! function_exists( 'yith_deactivate_plugins' ) ) {
			require_once 'plugin-fw/yit-deactive-plugin.php';
		}

		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_wcmap_install_woocommerce_admin_notice' );
		} elseif ( defined( 'YITH_WCMAP_EXTENDED_INIT' ) ) {
			yith_deactivate_plugins( 'YITH_WCMAP_EXTENDED_INIT' );
		} else {
			// Load required classes and functions.
			require_once 'includes/yith-wcmap-functions-premium.php';
			require_once 'includes/yith-wcmap-functions.php';
			require_once 'includes/class-yith-wcmap.php';
			// Let's start the game!
			YITH_WCMAP();
		}
	}
}

add_action( 'plugins_loaded', 'yith_wcmap_init', 11 );
register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

add_action( 'before_woocommerce_init', 'yith_wcmap_declare_hpos_compatibility' );

if ( ! function_exists( 'yith_wcmap_declare_hpos_compatibility' ) ) {
	/**
	 * Declare HPOS compatibility
	 *
	 * @return void
	 * @since  3.19.0
	 * @author Alessio Torrisi <alessio.torrisi@yithemes.com>
	 */
	function yith_wcmap_declare_hpos_compatibility() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
}
if ( ! defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

if ( ! class_exists( 'Code8_Admin_Notices' ) ) {

	class Code8_Admin_Notices {

		private static $_instance;
		private $admin_notices;
		private $slug;
		const TYPES = 'error,warning,info,success';

		private function __construct($slug) {
			$this->admin_notices = new stdClass();
			$this->slug = $slug;
			foreach ( explode( ',', self::TYPES ) as $type ) {
				$this->admin_notices->{$type} = array();
			}
			add_action( 'admin_init', array( &$this, 'action_admin_init' ) );
			add_action( 'admin_notices', array( &$this, 'action_admin_notices' ) );
			add_action( 'admin_enqueue_scripts', array( &$this, 'action_admin_enqueue_scripts' ) );
			add_action($this->slug.'_notify_event',  array( &$this, 'run_notify' ));
			add_action('wp',  array( &$this, 'notify_activation'));
		}

		public static function get_instance($slug) {
			if ( ! ( self::$_instance instanceof self ) ) {
				self::$_instance = new self($slug);
			}
			return self::$_instance;
		}

		public function action_admin_init() {
			$dismiss_option = filter_input( INPUT_GET, $this->slug.'_dismiss', FILTER_SANITIZE_STRING );
			if ( is_string( $dismiss_option ) ) {
				update_option( $this->slug."_dismissed_$dismiss_option", true );
				wp_die();
			}
		}

		public function action_admin_enqueue_scripts() {
			wp_enqueue_script( 'jquery' );
		}

		public  function notify_activation() {

            if ( !wp_next_scheduled( $this->slug.'_notify_event' ) ) {

                wp_schedule_event(time(), 'hourly', $this->slug.'_notify_event');
            }
        }
        public function run_notify() {

	        if ( ! get_option( $this->slug."_enable_notify" ) ) {

		        update_option( $this->slug."_enable_notify", 'false' );

	        }else {

		        update_option( $this->slug."_enable_notify", 'true' );

            }

        }

		public function action_admin_notices() {
			if ( ! get_option( $this->slug."_enable_notify" )  ||   get_option( $this->slug."_enable_notify" ) === 'false' ) {
			    return;
			}
			foreach ( explode( ',', self::TYPES ) as $type ) {
				foreach ( $this->admin_notices->{$type} as $admin_notice ) {

					$dismiss_url = add_query_arg( array(
						$this->slug.'_dismiss' => $admin_notice->dismiss_option
					), admin_url() );

					if ( ! get_option( $this->slug."_dismissed_{$admin_notice->dismiss_option}" ) ) {
						?><div
						class="notice <?php echo $this->slug;?>-notice notice-<?php echo $type;

						if ( $admin_notice->dismiss_option ) {
							echo ' is-dismissible" data-dismiss-url="' . esc_url( $dismiss_url );
						} ?>">

						<?php echo $admin_notice->message; ?>

						</div>
						<script>
                            /**
                             * Admin code for dismissing notifications.
                             *
                             */
                            (function( $ ) {
                                'use strict';
                                $( function() {
                                    $( '.<?php echo $this->slug;?>-notice' ).on( 'click', '.notice-dismiss', function( event, el ) {
                                        var $notice = $(this).parent('.notice.is-dismissible');
                                        var dismiss_url = $notice.attr('data-dismiss-url');
                                        if ( dismiss_url ) {
                                            $.get( dismiss_url );
                                        }
                                    });
                                } );
                            })( jQuery );
						</script><?php
					}
				}
			}
		}

		public function error( $message, $dismiss_option = false ) {
			$this->notice( 'error', $message, $dismiss_option );
		}

		public function warning( $message, $dismiss_option = false ) {
			$this->notice( 'warning', $message, $dismiss_option );
		}

		public function success( $message, $dismiss_option = false ) {
			$this->notice( 'success', $message, $dismiss_option );
		}

		public function info( $message, $dismiss_option = false ) {
			$this->notice( 'info', $message, $dismiss_option );
		}

		private function notice( $type, $message, $dismiss_option ) {
			$notice = new stdClass();
			$notice->message = $message;
			$notice->dismiss_option = $dismiss_option;

			$this->admin_notices->{$type}[] = $notice;
		}

		public static function error_handler( $errno, $errstr, $errfile, $errline, $errcontext ) {
			if ( ! ( error_reporting() & $errno ) ) {
				// This error code is not included in error_reporting
				return;
			}

			$message = "errstr: $errstr, errfile: $errfile, errline: $errline, PHP: " . PHP_VERSION . " OS: " . PHP_OS;

			$self = self::get_instance();

			switch ($errno) {
				case E_USER_ERROR:
					$self->error( $message );
					break;

				case E_USER_WARNING:
					$self->warning( $message );
					break;

				case E_USER_NOTICE:
				default:
					$self->notice( $message );
					break;
			}

			// write to wp-content/debug.log if logging enabled
			error_log( $message );

			// Don't execute PHP internal error handler
			return true;
		}
	}
}


$notice = Code8_Admin_Notices::get_instance('yith-my-account-page');
$notice->error( '<h2>تذکر مهم</h2>' .'<p>افزونه  YITH WooCommerce Customize My Account Page Premium توسط سایت لرن دی ال learndl.ir تهیه و بومی سازی شده است،اگر شما این افزونه را از سایتی غیر از سایت لرن دی ال تهیه کرده باشید،به صورت غیرقانونی به دست شما رسیده و باید به سایت لرن دی ال مراجعه کنید و گزارش دهید</p>', true  );